#!/usr/bin/python -u

import serial
import sys
import os
import rrdtool

# serial port of USB-WDE1
port = '/dev/ttyUSB0'

# MAIN
def main():
  # open serial line
  ser = serial.Serial(port, 9600)
  if not ser.isOpen():
    print("Unable to open serial port %s" % port)
    sys.exit(1)

  while(1==1):
    # read line from WDE1
    line = ser.readline()
    line = line.strip()
    #print(line)
    
    data = line.split(';')
    if (len(data) == 25 and data[0] == '$1' and data[24] == '0'):
      # data is valid 
      # re-format data into an update string for rrdtool
      for i, val in enumerate(data):
        data[i] = ('U' if val == '' else val.replace(',', '.'))
      update = 'N:' + ':'.join(data[3:24])
      #print(update)
      # insert data into database
      rrdtool.update(
        "%s/weather.rrd" % (os.path.dirname(os.path.abspath(__file__))),
        update)
      # terminate the program - we get invoked regularly from cron
      break 

  ser.close()

if __name__ == '__main__':
  main()
